package org.t2framework;

import org.t2framework.adapter.LucyContainerAdapter;

import commons.annotation.Published;

/**
 * T2 configuration keys.
 * 
 * @author shot
 */
@Published
public interface T2ConfigurationKey {

	/**
	 * Root package key for page class.
	 */
	String ROOT_PACKAGE_KEY = "t2.rootpackage";

	/**
	 * User external configuration key.
	 */
	String USER_CONFIG_KEY = "t2.config";

	/**
	 * Encoding key.
	 */
	String ENCODING_KEY = "t2.encoding";

	/**
	 * Exclude resources key T2 does not handle, like css/js.
	 */
	String EXCLUDE_RESOURCES_KEY = "t2.exclude-resources";

	/**
	 * ContainerAdapter class key.
	 */
	String CONTAINER_ADAPTER_CLASS = "t2.container.adapter";

	/**
	 * ContainerAdapter class.Default IoC container is Lucy.
	 */
	String DEFAULT_ADAPTER_CLASS = LucyContainerAdapter.class.getName();

	/**
	 * Eager loading page classes key.
	 */
	String EAGER_LODE_KEY = "t2.eagerload";
}
