package lucy.spi;

import lucy.ConfigBindResult;
import lucy.Lucy;

import commons.Disposable;

/**
 * ComponentBuilder is a SPI interface that builds a component using behaviors
 * from ConfigBindResult.
 * 
 * @author shot
 */
public interface ComponentBuilder extends Disposable {

	<T> T build(T t, final ConfigBindResult result);

	void setLucy(final Lucy lucy);

	ComponentBuilder loadConfiguration(final LucyConfiguration conf);
}
