package lucy.spi;

import lucy.Lifecycle;
import lucy.Lucy;

/**
 * Behavior is base interface deciding how Lucy behaves.The behavior class
 * always go with an configuration point just like InjectBehavior is for
 * &#064;Inject or InjectConfig.
 * 
 * <pre>
 * Behavior's constructor must have at least one of these:
 *  - BeanDesc, ClassDesc
 *  - BeanDesc, MethodDesc
 *  - BeanDesc, PropertyDesc
 * </pre>
 * 
 * @author shot
 */
public interface Behavior {

	<T> void init();

	<T> T execute(T t, Lucy lucy);

	<T> void destroy();

	Lifecycle getLifecycle();

	boolean isApplied(Lifecycle current);
}
