package lucy.spi;

import lucy.Lifecycle;

import commons.meta.BeanDesc;
import commons.meta.ClassDesc;
import commons.meta.ConfigDesc;
import commons.meta.MethodDesc;
import commons.meta.PropertyDesc;
import commons.util.Assertion;

/**
 * Convinient abstract Behavior class.
 * 
 * @author shot
 */
public abstract class AbstractBehavior implements Behavior {

	protected BeanDesc<Object> beanDesc;

	protected ClassDesc<Object> classDesc;

	protected MethodDesc methodDesc;

	protected PropertyDesc<Object> propertyDesc;

	protected ConfigDesc configDesc;

	/**
	 * Constructors are called by reflection.
	 * 
	 * @param beanDesc
	 * @param classDesc
	 * @param cd
	 */
	@SuppressWarnings("unchecked")
	public AbstractBehavior(BeanDesc beanDesc, ClassDesc classDesc,
			ConfigDesc cd) {
		this.beanDesc = Assertion.notNull(beanDesc);
		this.classDesc = Assertion.notNull(classDesc);
		this.configDesc = cd;
	}

	@SuppressWarnings("unchecked")
	public AbstractBehavior(BeanDesc beanDesc, MethodDesc md, ConfigDesc cd) {
		this.beanDesc = Assertion.notNull(beanDesc);
		this.methodDesc = Assertion.notNull(md);
		this.configDesc = cd;
	}

	@SuppressWarnings("unchecked")
	public AbstractBehavior(BeanDesc beanDesc, PropertyDesc pd, ConfigDesc cd) {
		this.beanDesc = Assertion.notNull(beanDesc);
		this.propertyDesc = Assertion.notNull(pd);
		this.configDesc = cd;
	}

	@Override
	public <T> void init() {
	}

	@Override
	public <T> void destroy() {
		beanDesc = null;
		classDesc = null;
		methodDesc = null;
		propertyDesc = null;
	}

	protected final BeanDesc<Object> getBeanDesc() {
		return beanDesc;
	}

	protected final ClassDesc<Object> getClassDesc() {
		return classDesc;
	}

	protected final MethodDesc getMethodDesc() {
		return methodDesc;
	}

	protected final PropertyDesc<Object> getPropertyDesc() {
		return propertyDesc;
	}

	protected final ConfigDesc getConfigDesc() {
		return configDesc;
	}

	@Override
	public boolean isApplied(Lifecycle current) {
		return current != null && current == getLifecycle();
	}

}
