package lucy.exception;

import commons.util.Assertion;

public class MethodNotFoundException extends LucyBaseRuntimeException {

	private static final long serialVersionUID = 1444059107210701494L;

	protected final Class<?> clazz;

	protected final String methodName;

	protected int lineNo;

	public MethodNotFoundException(Class<?> clazz, String methodName, int lineNo) {
		super("ELCY0006", clazz.getName(), methodName, lineNo);
		this.clazz = Assertion.notNull(clazz);
		this.methodName = Assertion.notNull(methodName);
		this.lineNo = Assertion.notNull(lineNo);
	}
}
