package lucy.exception;

import static commons.Constants.EMPTY_ARRAY;

import commons.exception.BaseRuntimeException;

/**
 * Base exception for any framework exceptions that throws in Lucy.
 * 
 * @author shot
 */
public class LucyBaseRuntimeException extends BaseRuntimeException {

	private static final long serialVersionUID = 1L;

	public LucyBaseRuntimeException() {
		this("ELCY0001", EMPTY_ARRAY);
	}

	public LucyBaseRuntimeException(String messageCode, Object... args) {
		this(null, messageCode, args);
	}

	public LucyBaseRuntimeException(Throwable cause, String messageCode,
			Object... args) {
		super(cause, messageCode, args);
	}

}
