package lucy.el.mvel;

import java.io.Serializable;

import lucy.Lucy;
import lucy.el.AbstractLucyExpression;

import org.mvel.MVEL;

public class MVELExpression extends AbstractLucyExpression {

	protected Serializable compiled;

	public MVELExpression(String source) {
		super(source);
		compiled = MVEL.compileExpression(source);
	}

	@Override
	public Object evaluate(Lucy lucy) {
		return MVEL.executeExpression(compiled, new LucyComponentMap(lucy));
	}

}
