package lucy.config.stax;

import java.util.Stack;

import javax.xml.stream.events.XMLEvent;

import lucy.Lucy;

import commons.util.Assertion;
import commons.util.CollectionsUtil;
import commons.util.StringUtil;

public class XmlEventContext {

	protected Stack<String> bodyStack = CollectionsUtil.newStack();

	protected Stack<Object> stack = CollectionsUtil.newStack();

	protected XMLEvent currentEvent;

	protected final Lucy lucy;

	public XmlEventContext(Lucy lucy) {
		this.lucy = Assertion.notNull(lucy);
	}

	public String peekBody() {
		return bodyStack.peek();
	}

	public String popBody() {
		return bodyStack.pop();
	}

	public void pushBody(String body) {
		if (!StringUtil.isEmpty(body)) {
			bodyStack.push(body);
		}
	}

	public void setCurrentEvent(XMLEvent event) {
		this.currentEvent = event;
	}

	public void clear() {
		bodyStack.clear();
		stack.clear();
		currentEvent = null;
	}

	public void push(Object object) {
		stack.push(object);
	}

	public Object pop() {
		return stack.pop();
	}

	public Object peek() {
		return stack.peek();
	}

	public Lucy getLucy() {
		return lucy;
	}
}
