package lucy.config.stax;

import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;

import commons.exception.XMLStreamRuntimeException;
import commons.util.Assertion;

public class XMLEventReaderDelegate implements XMLEventReader {

	protected final XMLEventReader original;

	protected XMLEvent before = null;

	public XMLEventReaderDelegate(XMLEventReader original) {
		this.original = Assertion.notNull(original);
	}

	public void close() throws XMLStreamRuntimeException {
		try {
			original.close();
		} catch (XMLStreamException e) {
			throw new XMLStreamRuntimeException(e);
		}
	}

	public String getElementText() throws XMLStreamRuntimeException {
		try {
			return original.getElementText();
		} catch (XMLStreamException e) {
			throw new XMLStreamRuntimeException(e);
		}
	}

	public Object getProperty(String name) throws IllegalArgumentException {
		return original.getProperty(name);
	}

	public boolean hasNext() {
		return original.hasNext();
	}

	public Object next() {
		Object next = original.next();
		return next;
	}

	public XMLEvent nextEvent() throws XMLStreamRuntimeException {
		try {
			return original.nextEvent();
		} catch (XMLStreamException e) {
			throw new XMLStreamRuntimeException(e);
		}
	}

	public XMLEvent nextTag() throws XMLStreamRuntimeException {
		try {
			return original.nextTag();
		} catch (XMLStreamException e) {
			throw new XMLStreamRuntimeException(e);
		}
	}

	public XMLEvent peek() throws XMLStreamRuntimeException {
		try {
			return original.peek();
		} catch (XMLStreamException e) {
			throw new XMLStreamRuntimeException(e);
		}
	}

	public void remove() {
		original.remove();
	}

}
