package lucy.config.stax;

import java.io.BufferedInputStream;
import java.net.URL;

import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

import lucy.Lucy;

import commons.util.Assertion;
import commons.util.ResourceUtil;
import commons.util.StAXUtil;
import commons.util.StreamUtil;
import commons.util.URLUtil;

public class StAXParser {

	protected final XmlEventHandlerRule rule;

	protected final XMLInputFactory factory;

	protected final LucyEventFilter filter = new LucyEventFilter();

	public StAXParser(XmlEventHandlerRule rule) {
		this.rule = Assertion.notNull(rule);
		this.factory = XMLInputFactory.newInstance();
		factory.setXMLResolver(new LucyXmlResolver());
	}

	public void parse(Lucy lucy, String path) {
		BufferedInputStream bis = getBufferedInputStream(path);
		XMLEventReaderDelegate reader = null;
		try {
			XMLEventReader org = StAXUtil.createXMLEventReader(factory, bis);
			XMLEventReader filteredReader = StAXUtil.createFilteredReader(
					factory, org, filter);
			reader = new XMLEventReaderDelegate(filteredReader);
			XmlEventContext context = new XmlEventContext(lucy);
			for (; reader.hasNext();) {
				XMLEvent event = reader.nextEvent();
				context.setCurrentEvent(event);
				if (event.isStartElement()) {
					StartElement se = event.asStartElement();
					Attributes attributes = new Attributes(se);
					String tagname = se.getName().getLocalPart();
					XmlEventHandler handler = rule.getHandler(tagname);
					handler.start(context, attributes);
				} else if (event.isEndElement()) {
					EndElement ee = event.asEndElement();
					String tagname = ee.getName().getLocalPart();
					XmlEventHandler handler = rule.getHandler(tagname);
					String body = context.popBody();
					handler.end(context, body);
				} else if (event.isCharacters()) {
					Characters c = event.asCharacters();
					context.pushBody(c.getData());
				}
			}
		} finally {
			if (reader != null) {
				reader.close();
			}
			if (bis != null) {
				StreamUtil.close(bis);
			}
		}

	}

	protected BufferedInputStream getBufferedInputStream(String path) {
		URL url = ResourceUtil.getResource(path);
		return new BufferedInputStream(URLUtil.openStream(url));
	}
}
