package lucy.config.stax;

import java.util.List;

import commons.meta.BeanDesc;
import commons.util.Assertion;
import commons.util.CollectionsUtil;

public class LucyConfigTagHandler implements XmlEventHandler {

	@Override
	public void start(XmlEventContext context, Attributes attributes) {
		context.clear();
		LucyConfig config = new LucyConfig();
		context.push(config);
	}

	@Override
	public void end(XmlEventContext context, String body) {
		LucyConfig config = (LucyConfig) context.pop();
		for (BeanDesc<?> bd : config.getBeanDescs()) {
			context.getLucy().register(bd);
		}
	}

	public static class LucyConfig {

		protected List<BeanDesc<?>> beanDescList = CollectionsUtil
				.newArrayList();

		public void addBeanDesc(BeanDesc<?> beanDesc) {
			beanDescList.add(Assertion.notNull(beanDesc));
		}

		public BeanDesc<?>[] getBeanDescs() {
			return beanDescList.toArray(new BeanDesc<?>[0]);
		}

	}
}
