package lucy.config.stax;

import java.util.List;

import lucy.config.meta.ConfigurableBeanDesc;
import lucy.config.meta.LifeCycleMethodDesc;
import lucy.exception.ArgumentMismatchException;
import lucy.exception.MethodNotFoundException;

import commons.meta.BeanDesc;
import commons.meta.MethodDesc;
import commons.util.StringUtil;

public abstract class LifeCycleTagHandler implements XmlEventHandler {

	protected abstract LifeCycleMethodDesc createConfigDesc();

	@Override
	public void start(XmlEventContext context, Attributes attributes) {
		ConfigurableBeanDesc<?> beanDesc = (ConfigurableBeanDesc<?>) context
				.peek();
		String name = attributes.getValue("method");
		if (StringUtil.isEmpty(name) == false) {
			MethodDesc md = find(context, beanDesc, name);
			if (md != null) {
				md.addConfigDesc(createConfigDesc());
			}
		}
	}

	protected MethodDesc find(XmlEventContext context, BeanDesc<?> bd,
			String name) {
		List<MethodDesc> list = bd.getMethodDescs(name);
		if (list == null || list.size() < 1) {
			throw new MethodNotFoundException(bd.getComponentClass(), name,
					context.currentEvent.getLocation().getLineNumber());
		}
		for (MethodDesc md : list) {
			Class<?>[] ary = md.getMethod().getParameterTypes();
			if (ary == null || ary.length == 0) {
				return md;
			}
		}
		throw new ArgumentMismatchException(bd.getComponentClass(), name,
				context.currentEvent.getLocation().getLineNumber());
	}

	@Override
	public void end(XmlEventContext context, String body) {
	}
}
