package lucy.config.stax;

import lucy.config.meta.ConfigurableBeanDesc;
import lucy.config.stax.LucyConfigTagHandler.LucyConfig;

import commons.meta.ClassDesc;
import commons.meta.InstanceConfigDescFactory;
import commons.meta.NameDesc;
import commons.meta.impl.ClassDescImpl;
import commons.meta.impl.NameDescImpl;
import commons.util.StringUtil;
import commons.util.Reflections.ClassUtil;

public class ComponentTagHandler implements XmlEventHandler {

	@Override
	public void start(XmlEventContext context, Attributes attributes) {
		String value = attributes.getValue("class");
		Class<?> c = null;
		if (!StringUtil.isEmpty(value)) {
			c = ClassUtil.forName(value);
		}
		ConfigurableBeanDesc<Object> beanDesc = new ConfigurableBeanDesc<Object>(
				c);
		String instance = attributes.getValue("instance");
		if (StringUtil.isEmpty(instance)) {
			instance = InstanceConfigDescFactory.DEFAULT;
		}
		beanDesc.setClassDesc(createClassDesc(c, instance));
		String name = attributes.getValue("name");
		if (!StringUtil.isEmpty(name)) {
			beanDesc.setNameDesc(createNameDesc(name));
		}
		context.push(beanDesc);
	}

	@Override
	public void end(XmlEventContext context, String body) {
		ConfigurableBeanDesc<?> beanDesc = (ConfigurableBeanDesc<?>) context
				.pop();
		LucyConfig config = (LucyConfig) context.peek();
		config.addBeanDesc(beanDesc);
	}

	protected ClassDesc<Object> createClassDesc(Class<?> clazz, String instance) {
		ClassDesc<Object> cd = new ClassDescImpl<Object>(clazz);
		cd.addConfigDesc(InstanceConfigDescFactory
				.getInstanceConfigDesc(instance));
		return cd;
	}

	protected NameDesc<Object> createNameDesc(String name) {
		return new NameDescImpl<Object>(name);
	}

}
