package lucy.config.stax;

import java.util.Iterator;
import java.util.Map;

import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;

import commons.util.Assertion;
import commons.util.CollectionsUtil;

public class Attributes {

	protected Map<String, Attribute> map = CollectionsUtil.newHashMap();

	@SuppressWarnings("unchecked")
	public Attributes(StartElement se) {
		Assertion.notNull(se);
		init(se.getAttributes());
	}

	public Attributes(Map<String, Attribute> map) {
		this.map = Assertion.notNull(map);
	}

	protected void init(Iterator<Attribute> iterator) {
		for (; iterator.hasNext();) {
			Attribute attribute = iterator.next();
			map.put(attribute.getName().getLocalPart(), attribute);
		}
	}

	public boolean hasAttribute(String name) {
		return map.containsKey(name);
	}

	public String getValue(String name) {
		Attribute attribute = map.get(name);
		return (attribute != null) ? attribute.getValue() : null;
	}

	public boolean isSpecifed(String name) {
		Attribute attribute = map.get(name);
		return (attribute != null) ? attribute.isSpecified() : false;
	}
}
