package lucy.config.stax;

import lucy.Lucy;
import lucy.aop.impl.PointcutImpl;
import lucy.config.meta.AspectConfigDescImpl;
import lucy.config.meta.ConfigurableBeanDesc;

import commons.aop.spi.Pointcut;
import commons.meta.AspectConfigDesc;
import commons.util.StringUtil;

public class AspectTagHandler implements XmlEventHandler {

	@SuppressWarnings("unchecked")
	@Override
	public void start(XmlEventContext context, Attributes attributes) {
		ConfigurableBeanDesc<?> beanDesc = (ConfigurableBeanDesc) context
				.peek();
		Class<?> componentClass = beanDesc.getComponentClass();
		String names = attributes.getValue("name");
		if (!StringUtil.isEmpty(names)) {
		}
		Pointcut pointcut = null;
		String patterns = attributes.getValue("pointcut");
		if (!StringUtil.isEmpty(patterns)) {
			String[] args = StringUtil.split(patterns, ",");
			pointcut = new PointcutImpl(args);
		} else {
			pointcut = new PointcutImpl();
		}
		AspectConfigDesc aspectConfigDesc = createAspectConfigDesc(context
				.getLucy(), componentClass, names, pointcut);
		context.push(aspectConfigDesc);
	}

	@Override
	public void end(XmlEventContext context, String body) {
		AspectConfigDesc aspectConfigDesc = (AspectConfigDesc) context.pop();
		AspectConfigDescAware aware = (AspectConfigDescAware) context.peek();
		aware.addAspectConfigDesc(aspectConfigDesc);
	}

	protected AspectConfigDesc createAspectConfigDesc(Lucy lucy,
			Class<?> componentClass, String names, Pointcut pointcut) {
		return new AspectConfigDescImpl(lucy, names, pointcut);
	}
}
