package lucy.config.meta;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.util.List;

import commons.meta.ConfigDesc;
import commons.meta.ConfigDescContainer;
import commons.meta.ConfigType;
import commons.util.CollectionsUtil;

public abstract class LifeCycleMethodDesc implements ConfigDesc {
	protected ConfigDescContainer container;

	@Override
	public ElementType[] getAcceptableTypes() {
		return ElementType.values();
	}

	@Override
	public Annotation getAnnotation() {
		return null;
	}

	@Override
	public ConfigDescContainer getConfigDescContainer() {
		return this.container;
	}

	@Override
	public ConfigType getConfigType() {
		return ConfigType.OUTER;
	}

	@Override
	public ElementType getElementType() {
		return ElementType.METHOD;
	}

	@Override
	public List<Annotation> getMetaAnnotationList() {
		return CollectionsUtil.emptyList();
	}

	@Override
	public Class<?> getType() {
		return getClass();
	}

	@Override
	public boolean hasAnnotation() {
		return false;
	}

	@Override
	public boolean isAcceptableType(ElementType type) {
		return true;
	}

	@Override
	public void setConfigDescContainer(ConfigDescContainer container) {
		this.container = container;
	}

	@Override
	public void setElementType(ElementType type) {
	}

}
