package lucy.config.meta;

import java.util.LinkedList;
import java.util.List;

import lucy.config.stax.AspectConfigDescAware;

import commons.meta.AspectConfigDesc;
import commons.meta.ClassDesc;
import commons.meta.ConfigDesc;
import commons.meta.ConfigDescContainer;
import commons.meta.ExpressionAware;
import commons.meta.MethodDesc;
import commons.meta.PropertyDesc;
import commons.meta.impl.BeanDescImpl;
import commons.util.Assertion;
import commons.util.CollectionsUtil;

public class ConfigurableBeanDesc<T> extends BeanDescImpl<T> implements
		AspectConfigDescAware {

	protected LinkedList<ExpressionAware> latests;

	public ConfigurableBeanDesc(Class<? extends T> componentClass) {
		super(componentClass);
	}

	@Override
	protected void init0() {
		super.init0();
		this.latests = new LinkedList<ExpressionAware>();
	}

	@SuppressWarnings("unchecked")
	public <D extends ExpressionAware> D getLatest() {
		return (D) latests.pollFirst();
	}

	@Override
	public void addMethodDesc(MethodDesc md) {
		final String methodName = md.getMethodName();
		List<MethodDesc> list = methodDescMap.get(methodName);
		if (list == null) {
			super.addMethodDesc(md);
			return;
		}
		if (!replaceMethodDesc(list, md)) {
			super.addMethodDesc(md);
		}
		replaceMethodDesc(methodDescList, md);
		addConfigList(md);
		latests.offerFirst(md);
	}

	protected void addConfigList(ConfigDescContainer container) {
		List<ConfigDesc> configList = getConfigMap().get(container);
		if (configList == null) {
			configList = CollectionsUtil.newArrayList();
		}
		List<ConfigDesc> list = container.getConfigDescs();
		if (!list.isEmpty()) {
			configList.addAll(list);
		}
		configMap.put(container, configList);
	}

	protected boolean replaceMethodDesc(List<MethodDesc> list, MethodDesc desc) {
		for (int i = 0; i < list.size(); ++i) {
			MethodDesc md = list.get(i);
			if (md.equals(desc)) {
				list.add(i, desc);
				return true;
			}
		}
		return false;
	}

	@Override
	public void addPropertyDesc(PropertyDesc<T> pd) {
		Assertion.notNull(pd);
		final String propertyName = pd.getPropertyName();
		PropertyDesc<T> propertyDesc = propertyDescMap.get(propertyName);
		if (propertyDesc == null) {
			super.addPropertyDesc(pd);
			return;
		}
		propertyDescMap.put(propertyName, pd);
		replacePropertyDesc(propertyDescList, pd);
		addConfigList(pd);
		latests.offerFirst(pd);
	}

	protected boolean replacePropertyDesc(List<PropertyDesc<T>> list,
			PropertyDesc<T> desc) {
		for (int i = 0; i < list.size(); ++i) {
			PropertyDesc<T> pd = list.get(i);
			if (pd.getPropertyName().equals(desc.getPropertyName())) {
				list.remove(i);
				list.add(i, desc);
				return true;
			}
		}
		return false;
	}

	@Override
	public void setClassDesc(ClassDesc<T> cd) {
		super.classDesc = cd;
		if (getConfigMap().containsKey(cd)) {
			synchronized (cd) {
				getConfigMap().remove(cd);
			}
		}
		addConfigList(cd);
	}

	@Override
	public void addAspectConfigDesc(AspectConfigDesc aspectConfigDesc) {
		getClassDesc().addConfigDesc(aspectConfigDesc);
	}

}
