package lucy.config.meta;

import java.util.List;

import lucy.Lucy;
import lucy.aop.impl.AspectImpl;
import commons.aop.spi.Aspect;
import commons.aop.spi.Interceptor;
import commons.aop.spi.Pointcut;
import commons.meta.impl.AbstractAspectConfigDesc;
import commons.util.Assertion;
import commons.util.CollectionsUtil;
import commons.util.StringUtil;

public class AspectConfigDescImpl extends AbstractAspectConfigDesc {

	protected Lucy lucy;

	protected Class<?> targetClass;

	protected String[] interceptorNames = new String[0];

	protected Pointcut pointcut;

	public AspectConfigDescImpl(Lucy lucy, String names, Pointcut pointcut) {
		this.lucy = Assertion.notNull(lucy);
		this.interceptorNames = StringUtil.split(Assertion.notNull(names), ",");
		this.pointcut = Assertion.notNull(pointcut);
	}

	@Override
	public String[] getInterceptorNames() {
		return interceptorNames;
	}

	@Override
	public Pointcut getPointcut() {
		return pointcut;
	}

	@Override
	public Class<?> getTargetClass() {
		return targetClass;
	}

	@Override
	public void setInterceptorNames(String[] names) {
		Assertion.notNull(names);
		this.interceptorNames = Assertion.notNulls(names);
	}

	@Override
	public void setPointcut(Pointcut pointcut) {
		this.pointcut = Assertion.notNull(pointcut);
	}

	@Override
	public void setTargetClass(Class<?> targetClass) {
		this.targetClass = Assertion.notNull(targetClass);
	}

	@Override
	public String getName() {
		return "aspect";
	}

	@Override
	public Aspect createAspect() {
		List<Interceptor> list = CollectionsUtil.newArrayList();
		for (String n : interceptorNames) {
			Interceptor interceptor = lucy.get(n);
			if (interceptor != null) {
				list.add(interceptor);
			}
		}
		Aspect aspect = new AspectImpl(list);
		aspect.setPointcut(pointcut);
		return aspect;
	}

}
