package lucy.behavior;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

import lucy.Lifecycle;
import lucy.Lucy;
import lucy.SingletonCache;
import lucy.spi.AbstractBehavior;

import commons.Constants;
import commons.annotation.ConfigurationTarget;
import commons.annotation.core.Singleton;
import commons.meta.BeanDesc;
import commons.meta.ClassDesc;
import commons.meta.ConfigDesc;
import commons.meta.impl.SingletonInstanceConfigDesc;

/**
 * SingletonBehavior is singleton behavior for component.
 * 
 * @author shot
 */
@ConfigurationTarget( { Singleton.class, SingletonInstanceConfigDesc.class })
public class SingletonBehavior extends AbstractBehavior {

	protected Lock lock = new ReentrantLock();

	public SingletonBehavior(BeanDesc<?> beanDesc, ClassDesc<?> classDesc,
			ConfigDesc cd) {
		super(beanDesc, classDesc, cd);
	}

	@SuppressWarnings("unchecked")
	@Override
	public <T> T execute(T t, Lucy lucy) {
		ClassDesc<Object> cd = getClassDesc();
		Class<?> c = cd.getConcreteClass();
		lock.lock();
		try {
			Object ret = SingletonCache.get(c);
			if (ret == null) {
				BeanDesc<Object> beanDesc = getBeanDesc();
				beanDesc.setSingleton(true);
				ret = beanDesc.getComponent();
				if (ret == null) {
					ret = beanDesc.newInstance(Constants.EMPTY_ARRAY);
					beanDesc.setComponent(ret);
				}
				SingletonCache.save(c, ret);
			}
			t = (T) ret;
		} finally {
			lock.unlock();
		}
		return t;
	}

	@Override
	public void destroy() {
		super.destroy();
		SingletonCache.clear();
	}

	@Override
	public Lifecycle getLifecycle() {
		return Lifecycle.COMPONENT_CREATING;
	}

}
