package lucy.behavior;

import static lucy.Lifecycle.COMPONENT_CREATING;
import lucy.Lifecycle;
import lucy.Lucy;
import lucy.spi.AbstractBehavior;

import commons.Constants;
import commons.annotation.ConfigurationTarget;
import commons.annotation.core.Prototype;
import commons.meta.BeanDesc;
import commons.meta.ClassDesc;
import commons.meta.ConfigDesc;
import commons.meta.impl.PrototypeInstanceConfigDesc;

/**
 * PrototypeBehavior creates instance every time it is called.
 * 
 * @author shot
 */
@ConfigurationTarget( { Prototype.class, PrototypeInstanceConfigDesc.class })
public class PrototypeBehavior extends AbstractBehavior {

	public PrototypeBehavior(BeanDesc<?> beanDesc, ClassDesc<?> classDesc,
			ConfigDesc cd) {
		super(beanDesc, classDesc, cd);
	}

	@SuppressWarnings("unchecked")
	@Override
	public <T> T execute(T t, Lucy lucy) {
		t = (T) getBeanDesc().newInstance(Constants.EMPTY_ARRAY);
		return t;
	}

	@Override
	public Lifecycle getLifecycle() {
		return COMPONENT_CREATING;
	}

}
