package lucy.behavior;

import java.util.Map;

import lucy.Lifecycle;
import lucy.Lucy;
import lucy.annotation.core.InitMethod;
import lucy.config.meta.InitMethodDesc;
import lucy.spi.AbstractBehavior;

import commons.Constants;
import commons.annotation.ConfigurationTarget;
import commons.meta.BeanDesc;
import commons.meta.ConfigDesc;
import commons.meta.MethodDesc;
import commons.util.CollectionsUtil;

/**
 * InitMethodBehavior is a behavior class for &#064;Init.
 * 
 * @author shot
 */
@ConfigurationTarget( { InitMethod.class, InitMethodDesc.class })
public class InitMethodBehavior extends AbstractBehavior {

	protected Map<MethodDesc, Object> initedCache = CollectionsUtil
			.newHashMap();

	@SuppressWarnings("unchecked")
	public InitMethodBehavior(BeanDesc beanDesc, MethodDesc md, ConfigDesc cd) {
		super(beanDesc, md, cd);
	}

	@Override
	public <T> T execute(T t, Lucy lucy) {
		MethodDesc methodDesc = getMethodDesc();
		if (methodDesc != null) {
			if (!this.initedCache.containsKey(methodDesc)) {
				methodDesc.invoke(t, Constants.EMPTY_ARRAY);
				this.initedCache.put(methodDesc, t);
			}
		}
		return t;
	}

	@Override
	public <T> void destroy() {
		this.initedCache.clear();
	}

	@Override
	public Lifecycle getLifecycle() {
		return Lifecycle.COMPONENT_INITIALIZE;
	}
}
