package lucy.behavior;

import java.util.Map;

import lucy.Lifecycle;
import lucy.Lucy;
import lucy.annotation.core.DestroyMethod;
import lucy.config.meta.DestroyMethodDesc;
import lucy.spi.AbstractBehavior;

import commons.Constants;
import commons.Disposable;
import commons.Disposer;
import commons.annotation.ConfigurationTarget;
import commons.meta.BeanDesc;
import commons.meta.ConfigDesc;
import commons.meta.MethodDesc;
import commons.util.CollectionsUtil;

/**
 * DestroyMethodBehavior is a behavior class for &#064;Destory.
 * 
 * @author taichi
 */
@ConfigurationTarget( { DestroyMethod.class, DestroyMethodDesc.class })
public class DestroyMethodBehavior extends AbstractBehavior {

	protected Map<MethodDesc, Object> destroyedCache = CollectionsUtil
			.newHashMap();

	@SuppressWarnings("unchecked")
	public DestroyMethodBehavior(BeanDesc beanDesc, MethodDesc md, ConfigDesc cd) {
		super(beanDesc, md, cd);
	}

	@Override
	public <T> T execute(final T t, Lucy lucy) {
		final MethodDesc methodDesc = getMethodDesc();
		if (methodDesc != null) {
			if (!this.destroyedCache.containsKey(methodDesc)) {
				Disposer.add(new Disposable() {
					@Override
					public void dispose() {
						methodDesc.invoke(t, Constants.EMPTY_ARRAY);
						DestroyMethodBehavior.this.destroyedCache.put(
								methodDesc, t);
					}
				});
			}
		}
		return t;
	}

	@Override
	public <T> void destroy() {
		this.destroyedCache.clear();
	}

	@Override
	public Lifecycle getLifecycle() {
		return Lifecycle.COMPONENT_DESTROY;
	}
}
