package lucy.behavior;

import java.util.List;

import lucy.Lifecycle;
import lucy.Lucy;
import lucy.aop.impl.AspectAssemblerImpl;
import lucy.spi.AbstractBehavior;

import commons.annotation.ConfigurationTarget;
import commons.aop.AopEngine;
import commons.aop.AspectAssembler;
import commons.aop.spi.Aspect;
import commons.bootstrap.CommonsInitializer;
import commons.meta.AspectConfigDesc;
import commons.meta.BeanDesc;
import commons.meta.ClassDesc;
import commons.meta.ConfigDesc;

/**
 * AspectBehavior is a behavior class for enhancing component.
 * 
 * @author shot
 */
@ConfigurationTarget( { commons.annotation.core.Aspect.class,
		AspectConfigDesc.class })
public class AspectBehavior extends AbstractBehavior {

	protected AspectAssembler<Lucy> aspectAssembler;

	protected AopEngine engine;

	@SuppressWarnings("unchecked")
	public AspectBehavior(BeanDesc beanDesc, ClassDesc classDesc, ConfigDesc cd) {
		super(beanDesc, classDesc, cd);
	}

	@Override
	public <T> void init() {
		aspectAssembler = new AspectAssemblerImpl<Lucy>();
		engine = CommonsInitializer.getFactory().getAopEngine();
	}

	@Override
	public <T> T execute(T t, Lucy lucy) {
		// @Aspect handles just once, not twice or more.
		BeanDesc<Object> beanDesc = getBeanDesc();
		synchronized (beanDesc) {
			if (beanDesc.getEnhancedComponentClass() != null) {
				return t;
			}
		}
		Class<? extends Object> originalClass = beanDesc.getComponentClass();
		List<Aspect> aspects = aspectAssembler.assemble(beanDesc, lucy);
		Class<? extends Object> enhancedClass = engine.getEnhancedClass(
				originalClass, aspects);
		synchronized (beanDesc) {
			beanDesc.setEnhancedComponentClass(enhancedClass);
		}
		return t;
	}

	@Override
	public <T> void destroy() {
		super.destroy();
		aspectAssembler = null;
	}

	@Override
	public Lifecycle getLifecycle() {
		return Lifecycle.CLASS_LOADING;
	}

}
