package lucy.aop.impl;

import java.util.Map;

import commons.util.Assertion;
import commons.util.CollectionsUtil;

import lucy.aop.EnhancedClassCache;

public class SimpleEnahncedClassCacheImpl implements EnhancedClassCache {

	protected Map<Class<?>, Class<?>> classCache = CollectionsUtil
			.newSynchronizedWeakHashMap();

	@SuppressWarnings("unchecked")
	@Override
	public <T> void cache(final Class<? extends T> originalClass,
			final Class<? extends T> enhancedClass) {
		Assertion.notNulls(originalClass, enhancedClass);
		classCache.put(originalClass, enhancedClass);
	}

	@Override
	public <T> void clear(Class<? extends T> originalClass) {
		classCache.remove(originalClass);
	}

	@Override
	public void clear() {
		classCache.clear();
	}

	@SuppressWarnings("unchecked")
	@Override
	public <T> Class<? extends T> get(Class<? extends T> originalClass) {
		return (Class<? extends T>) classCache.get(originalClass);
	}

}
