package lucy.aop.impl;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.List;
import java.util.regex.Pattern;

import commons.aop.spi.Pointcut;
import commons.util.Assertion;
import commons.util.CollectionsUtil;
import commons.util.PatternUtil;

public class PointcutImpl implements Pointcut, Serializable {

	static final long serialVersionUID = 0L;

	protected String[] regexes;

	protected List<Pattern> patterns;

	protected boolean perfectMatch = false;

	public PointcutImpl() {
		this(false, new String[] { DEFAULT_REGEX });
	}

	public PointcutImpl(String... regexes) {
		this(false, Assertion.notNulls(regexes));
	}

	public PointcutImpl(boolean perfectMatch, String... regexes) {
		this.perfectMatch = perfectMatch;
		this.regexes = regexes;
		createPatterns(regexes);
	}

	protected void createPatterns(String[] regexes) {
		this.patterns = CollectionsUtil.newArrayList();
		for (String regex : regexes) {
			patterns.add(PatternUtil.getPattern(regex));
		}
	}

	@Override
	public List<Pattern> getPatterns() {
		return patterns;
	}

	protected boolean match(final String methodName) {
		if (perfectMatch) {
			for (String name : regexes) {
				if (name.equals(methodName)) {
					return true;
				}
			}
			return false;
		}
		for (Pattern p : patterns) {
			if (p.matcher(methodName).matches()) {
				return true;
			}
		}
		return false;
	}

	@Override
	public String[] getPatternStrings() {
		return regexes;
	}

	@Override
	public boolean isApplied(Method method) {
		final String methodName = Assertion.notNull(method).getName();
		return match(methodName);
	}

}
