package lucy.aop.impl;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;

import javassist.Modifier;
import lucy.aop.AspectDesc;
import lucy.aop.InterceptorDesc;
import lucy.aop.InterceptorDescStrategy;

import commons.aop.spi.Aspect;
import commons.aop.spi.Interceptor;
import commons.meta.BeanDesc;
import commons.meta.MethodDesc;
import commons.meta.PropertyDesc;
import commons.util.Assertion;
import commons.util.CollectionsUtil;

/**
 * @author shot
 */
public class InterceptorDescStrategyImpl implements InterceptorDescStrategy {

	@Override
	public <T> Map<AccessibleObject, InterceptorDesc> assemble(
			final BeanDesc<T> beanDesc, final AspectDesc aspectDesc) {
		Assertion.notNulls(beanDesc, aspectDesc);
		Map<AccessibleObject, InterceptorDesc> map = CollectionsUtil
				.newHashMap();
		assemleByPropertyDesc(map, beanDesc, aspectDesc);
		assemleByMethodDesc(map, beanDesc, aspectDesc);
		return map;
	}

	protected <T> void assemleByPropertyDesc(
			final Map<AccessibleObject, InterceptorDesc> map,
			final BeanDesc<T> beanDesc, final AspectDesc aspectDesc) {
		for (PropertyDesc<T> pd : beanDesc.getAllPropertyDesc()) {
			if (pd.isReadable()) {
				assemble0(map, pd.getReadMethod(), aspectDesc);
			}
			if (pd.isWritable()) {
				assemble0(map, pd.getWriteMethod(), aspectDesc);
			}
		}
	}

	protected <T> void assemleByMethodDesc(
			final Map<AccessibleObject, InterceptorDesc> map,
			final BeanDesc<T> beanDesc, final AspectDesc aspectDesc) {
		for (MethodDesc md : beanDesc.getAllMethodDesc()) {
			assemble0(map, md.getMethod(), aspectDesc);
		}
	}

	protected <T> void assemble0(Map<AccessibleObject, InterceptorDesc> map,
			Method method, AspectDesc aspectDesc) {
		List<Interceptor> list = CollectionsUtil.newArrayList();
		if (method == null) {
			return;
		}
		for (Aspect a : aspectDesc.getAspects()) {
			if (a.getPointcut().isApplied(method)) {
				list.addAll(a.getInterceptors());
			}
		}
		int mod = method.getModifiers();
		if (list.size() == 0 || Modifier.isFinal(mod)) {
			return;
		}
		map.put(method, createInterceptorDesc(method, list));
	}

	protected InterceptorDesc createInterceptorDesc(Method method,
			List<Interceptor> list) {
		return new InterceptorDescImpl(method, list);
	}

}
