package lucy.aop.impl;

import java.lang.reflect.Method;
import java.util.List;

import lucy.aop.InterceptorDesc;

import commons.aop.spi.Interceptor;
import commons.util.Assertion;

public class InterceptorDescImpl implements InterceptorDesc {

	protected Method method;

	protected List<Interceptor> interceptors;

	public InterceptorDescImpl(Method method, List<Interceptor> interceptors) {
		Assertion.notNulls(method, interceptors);
		this.method = method;
		this.interceptors = interceptors;
	}

	@Override
	public List<Interceptor> getInterceptors() {
		return interceptors;
	}

	@Override
	public Method getMethod() {
		return method;
	}
}
