package lucy.aop.impl;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.CtNewMethod;
import lucy.aop.AspectDesc;
import lucy.aop.CannotCompileRuntimeException;
import lucy.aop.ClassPoolUtil;
import lucy.aop.JavassistUtil;
import lucy.aop.LucyClassPool;

import commons.util.Assertion;

public class ClassEnhanceHelper {

	public static CtClass makeCtClass(AspectDesc aspectDesc) {
		Assertion.notNull(aspectDesc);
		final String enhancedClassName = aspectDesc.getEnhancedClassName();
		final Class<?> originalClass = aspectDesc.getOriginalClass();
		ClassPool pool = ClassPoolUtil.getClassPool(originalClass);

		boolean isInterface = aspectDesc.isInterfaceTarget();
		Class<?> clazz = isInterface ? Object.class : originalClass;
		CtClass ctClass = JavassistUtil.makeCtClass(pool, enhancedClassName,
				clazz);
		if (isInterface) {
			CtClass originalCtClass = JavassistUtil.getCtClass(pool,
					originalClass);
			ctClass.setInterfaces(new CtClass[] { originalCtClass });
		} else {
			Class<?>[] interfaces = originalClass.getInterfaces();
			CtClass[] ctClassArray = JavassistUtil.getCtClassArray(pool,
					interfaces);
			ctClass.setInterfaces(ctClassArray);
		}
		JavassistUtil.addDefaultConstructor(ctClass);
		return ctClass;
	}

	public static void addCtNewMethod(final AspectDesc aspectDesc,
			final CtClass enhancedCtClass, final Method method,
			final String methodName, final String body) {
		LucyClassPool pool = ClassPoolUtil.getClassPool(aspectDesc
				.getOriginalClass());
		CtMethod ctMethod = LucyCtNewMethod.make(enhancedCtClass, pool, method,
				methodName, body);
		try {
			enhancedCtClass.addMethod(ctMethod);
		} catch (CannotCompileException e) {
			throw new CannotCompileRuntimeException(e);
		}
	}

	public static class LucyCtNewMethod extends CtNewMethod {

		public static CtMethod make(CtClass enhancedCtClass,
				LucyClassPool pool, Method method, String methodName,
				String body) {
			final CtClass returnType = JavassistUtil.getCtClass(pool, method
					.getReturnType());
			final CtClass[] parameters = JavassistUtil.getCtClassArray(pool,
					method.getParameterTypes());
			final CtClass[] exceptions = JavassistUtil.getCtClassArray(pool,
					method.getExceptionTypes());
			try {
				CtMethod cm = new CtMethod(returnType, methodName, parameters,
						enhancedCtClass);
				final int mod = method.getModifiers()
						& ~(Modifier.ABSTRACT | Modifier.NATIVE);
				cm.setModifiers(mod);
				cm.setExceptionTypes(exceptions);
				cm.setBody(body);
				return cm;
			} catch (Exception e) {
				throw new CannotCompileRuntimeException(e);
			}
		}

	}
}
