package lucy.aop.impl;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;

import commons.aop.spi.Aspect;
import commons.aop.spi.Interceptor;
import commons.aop.spi.Pointcut;
import commons.util.Assertion;

public class AspectImpl implements Aspect, Serializable {

	static final long serialVersionUID = 0L;

	protected List<Interceptor> interceptors;

	protected Pointcut pointcut;

	public AspectImpl(Interceptor... interceptors) {
		this(Arrays.asList(interceptors));
	}

	public AspectImpl(String regex, Interceptor... interceptors) {
		this(new String[] { Assertion.notNull(regex) }, Arrays
				.asList(interceptors));
	}

	public AspectImpl(String[] regexes, Interceptor... interceptors) {
		this(Assertion.notNulls(regexes), Arrays.asList(interceptors));
	}

	public AspectImpl(List<Interceptor> interceptors) {
		this(Pointcut.DEFAULT_REGEX, Assertion.notNull(interceptors));
	}

	public AspectImpl(String regex, List<Interceptor> interceptors) {
		this(new String[] { Assertion.notNull(regex) }, interceptors);
	}

	public AspectImpl(String[] regexes, List<Interceptor> interceptors) {
		this(regexes, interceptors, false);
	}

	public AspectImpl(String methodName, List<Interceptor> interceptors,
			boolean perfectMatch) {
		this(new String[] { Assertion.notNull(methodName) }, interceptors,
				perfectMatch);
	}

	public AspectImpl(String[] regexes, List<Interceptor> interceptors,
			boolean perfectMatch) {
		this.interceptors = Assertion.notNull(interceptors);
		this.pointcut = new PointcutImpl(perfectMatch, regexes);
	}

	@Override
	public Pointcut getPointcut() {
		return pointcut;
	}

	@Override
	public void setPointcut(Pointcut pointcut) {
		this.pointcut = Assertion.notNull(pointcut);
	}

	@Override
	public List<Interceptor> getInterceptors() {
		return interceptors;
	}

}
