package lucy.aop.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

import lucy.aop.AspectDesc;

import commons.aop.spi.Aspect;
import commons.util.Assertion;
import commons.util.CollectionsUtil;

import static lucy.aop.AopConstants.PREFIX_ENHANCED_CLASS;
import static lucy.aop.AopConstants.SUFFIX_ENHANCED_CLASS;

public class AspectDescImpl implements AspectDesc {

	protected static final Set<String> enhancedClassNames = CollectionsUtil
			.newConcurrentHashSet();

	protected Class<?> originalClass;

	protected Class<?> enhancedClass;

	protected String enhancedClassName;

	protected List<Aspect> aspects = Collections.emptyList();

	protected Map<String, Object> parameters = null;

	protected boolean interface_ = false;

	public AspectDescImpl(Class<?> originalClass, List<Aspect> aspects) {
		this(originalClass, aspects, new HashMap<String, Object>());
	}

	public AspectDescImpl(Class<?> originalClass, List<Aspect> aspects,
			Map<String, Object> parameters) {
		this.originalClass = Assertion.notNull(originalClass);
		this.aspects = Assertion.notNull(aspects);
		this.parameters = Assertion.notNull(parameters);
		createEnhancedClassName();
		this.interface_ = this.originalClass.isInterface();
	}

	protected void createEnhancedClassName() {
		final StringBuffer buf = new StringBuffer(200);
		final String targetClassName = originalClass.getName();
		final Package pkg = originalClass.getPackage();
		if (targetClassName.startsWith("java.")
				|| (pkg != null && pkg.isSealed())) {
			buf.append(PREFIX_ENHANCED_CLASS);
		}
		buf.append(targetClassName).append(SUFFIX_ENHANCED_CLASS).append(
				Integer.toHexString(hashCode()));
		final int length = buf.length();
		for (int i = 0; enhancedClassNames.contains(new String(buf)); ++i) {
			buf.setLength(length);
			buf.append("_").append(i);
		}
		this.enhancedClassName = buf.toString();
		enhancedClassNames.add(enhancedClassName);
	}

	@Override
	public List<Aspect> getAspects() {
		return aspects;
	}

	@Override
	public Class<?> getEnhancedClass() {
		return enhancedClass;
	}

	@Override
	public String getEnhancedClassName() {
		return enhancedClassName;
	}

	@Override
	public Class<?> getOriginalClass() {
		return originalClass;
	}

	@Override
	public Map<String, Object> getParameters() {
		return parameters;
	}

	@Override
	public void setEnhancedClass(Class<?> enhancedClass) {
		this.enhancedClass = enhancedClass;
	}

	@Override
	public void setEnhancedClassName(String name) {
		this.enhancedClassName = name;
	}

	@Override
	public boolean isInterfaceTarget() {
		return interface_;
	}

}