package lucy.aop.impl;

import java.util.Arrays;
import java.util.List;

import lucy.Lucy;

import commons.annotation.core.Aspect;
import commons.aop.AspectAssembler;
import commons.aop.spi.Interceptor;
import commons.meta.AspectConfigDesc;
import commons.meta.BeanDesc;
import commons.meta.ClassDesc;
import commons.meta.ConfigDesc;
import commons.meta.ConfigDescContainer;
import commons.meta.MethodDesc;
import commons.util.CollectionsUtil;

public class AspectAssemblerImpl<C extends Lucy> implements AspectAssembler<C> {

	public AspectAssemblerImpl() {
	}

	@Override
	public <T> List<commons.aop.spi.Aspect> assemble(BeanDesc<T> beanDesc,
			C lucy) {
		commons.aop.spi.Aspect[] rootAspects = createRootAspects(beanDesc
				.getClassDesc(), lucy);
		List<commons.aop.spi.Aspect> retList = CollectionsUtil.newArrayList();
		List<ConfigDesc> configs = beanDesc
				.getMethodConfigDescList(Aspect.class);
		if (configs != null) {
			for (ConfigDesc conf : configs) {
				commons.aop.spi.Aspect methodAspect = createAspect(conf, lucy,
						rootAspects);
				retList.add(methodAspect);
			}
		}
		if (rootAspects != null && rootAspects.length > 0) {
			retList.addAll(Arrays.asList(rootAspects));
		}
		for (ConfigDesc configDesc : beanDesc
				.getClassConfigDescList(AspectConfigDesc.class)) {
			retList.add(((AspectConfigDesc) configDesc).createAspect());
		}
		return retList;
	}

	@SuppressWarnings("unchecked")
	protected <T> commons.aop.spi.Aspect[] createRootAspects(
			final ClassDesc<T> cd, final Lucy lucy) {
		List<ConfigDesc> confs = cd.findConfigDescs(Aspect.class);
		if (confs == null) {
			return null;
		}
		commons.aop.spi.Aspect[] rootAspects = new commons.aop.spi.Aspect[confs
				.size()];
		int i = 0;
		for (ConfigDesc conf : confs) {
			Aspect aspect = getAspect(conf);
			if (aspect == null) {
				continue;
			}
			Class<? extends Interceptor>[] classes = aspect.interceptBy();
			List<Interceptor> interceptors = CollectionsUtil.newArrayList();
			for (int j = 0; j < classes.length; j++) {
				Interceptor interceptor = lucy
						.get((Class<Interceptor>) classes[i]);
				interceptors.add(interceptor);
			}
			String[] regexes = aspect.pointcut();
			rootAspects[i++] = createAspect(regexes, interceptors, false);
		}
		return rootAspects;
	}

	@SuppressWarnings("unchecked")
	protected <T> commons.aop.spi.Aspect createAspect(final ConfigDesc conf,
			final Lucy lucy, final commons.aop.spi.Aspect[] rootAspect) {
		Aspect aspect = getAspect(conf);
		if (aspect == null) {
			return null;
		}
		Class<? extends Interceptor>[] classes = aspect.interceptBy();
		List<Interceptor> interceptors = CollectionsUtil.newArrayList();
		for (int i = 0; i < classes.length; i++) {
			Interceptor interceptor = lucy.get((Class<Interceptor>) classes[i]);
			interceptors.add(interceptor);
		}
		String[] regexes = aspect.pointcut();
		return createAspect(conf, regexes, interceptors, rootAspect);
	}

	protected Aspect getAspect(ConfigDesc configDesc) {
		if (configDesc.hasAnnotation()) {
			return (Aspect) configDesc.getAnnotation();
		}
		return null;
	}

	protected <T> commons.aop.spi.Aspect createAspect(final ConfigDesc conf,
			final String[] regexes, final List<Interceptor> interceptors,
			final commons.aop.spi.Aspect[] rootAspect) {
		ConfigDescContainer container = conf.getConfigDescContainer();
		String[] names = null;
		if (MethodDesc.class.isInstance(container)) {
			MethodDesc md = MethodDesc.class.cast(container);
			names = new String[] { md.getMethodName() };
		} else {
			throw new IllegalStateException("aspect should be on Method");
		}
		return createAspect(names, interceptors, true);
	}

	protected commons.aop.spi.Aspect createAspect(String[] regexes,
			List<Interceptor> interceptors, boolean perfectMatch) {
		return new AspectImpl(regexes, interceptors, perfectMatch);
	}

}
