package lucy.aop;

import java.util.Map;

import javassist.LoaderClassPath;

import commons.util.Assertion;
import commons.util.CollectionsUtil;
import commons.util.Reflections.ClassLoaderUtil;

/**
 * @author shot
 */
public class ClassPoolUtil {

	protected static Map<ClassLoader, LucyClassPool> cache = CollectionsUtil
			.newSynchronizedWeakHashMap();

	public static LucyClassPool getClassPool(final Class<?> clazz) {
		Assertion.notNull(clazz);
		ClassLoader classLoader = ClassLoaderUtil.getClassLoader(clazz);
		LucyClassPool pool = cache.get(classLoader);
		if (pool != null) {
			return pool;
		}
		pool = new LucyClassPool();
		pool.appendClassPath(new LoaderClassPath(classLoader));
		cache.put(classLoader, pool);
		return pool;
	}

	public static void clearCache() {
		cache.clear();
	}

}
