package lucy.annotation.core;

import static java.lang.annotation.ElementType.METHOD;
import static java.lang.annotation.RetentionPolicy.RUNTIME;

import java.lang.annotation.Retention;
import java.lang.annotation.Target;

import lucy.LucyBootstrap;

/**
 * &#064;Inject annotation is the annotation which is needed <br /> when you
 * want to inject something.<br />
 * 
 * Lucy supports only setter injection type IoC. <br /> (currently in now, but
 * nobody knows future)
 * 
 * @author shot
 */
@Retention(RUNTIME)
@Target( { METHOD })
public @interface Inject {

	String FROM = "from";

	String TYPES = "types";

	/**
	 * from attributes point out where the injection target comes from. Default
	 * is Lucy, which means gets from Lucy.
	 * 
	 * @return
	 */
	Class<?>[] from() default LucyBootstrap.class;

	/**
	 * types() are used when inject multiple component to one method.
	 */
	Class<?>[] types() default Object.class;
}
