package lucy;

import lucy.config.stax.LucyConfigTagHandlerRule;
import lucy.config.stax.StAXParser;

/**
 * ComponentRegistrar for external xml configuration.
 * 
 * @author shot
 */
public class XMLLucyComponentRegistrar implements
		LucyComponentRegistrar<String> {

	public static final String SUFFIX = ".xml";

	protected StAXParser parser = new StAXParser(new LucyConfigTagHandlerRule());

	public void setStAXParser(StAXParser parser) {
		this.parser = parser;
	}

	@Override
	public void register(Lucy lucy, String resource) {
		parser.parse(lucy, resource);
	}

	@Override
	public boolean accepts(Object resource) {
		if (!(resource instanceof String)) {
			return false;
		}
		return ((String) resource).endsWith(SUFFIX);
	}
}
