package lucy;

import java.util.Map;

import commons.util.Assertion;
import commons.util.CollectionsUtil;

/**
 * Simple singleton cache.
 * 
 * @author shot
 */
public class SingletonCache {

	private static final Map<Class<?>, Object> cache = CollectionsUtil
			.newConcurrentHashMap();

	@SuppressWarnings("unchecked")
	public static <T> T get(Class<? extends T> clazz) {
		return (T) cache.get(clazz);
	}

	public static <T> void save(Class<? extends T> clazz, T t) {
		cache.put(Assertion.notNull(clazz), Assertion.notNull(t));
	}

	public static int size() {
		return cache.size();
	}

	public static void clear() {
		cache.clear();
	}
}
