package lucy;

import lucy.aop.impl.AopEngineImpl;
import lucy.aop.impl.InterceptorDescStrategyImpl;
import lucy.aop.impl.SimpleEnahncedClassCacheImpl;
import commons.annotation.Composite;
import commons.aop.AopEngine;
import commons.bootstrap.CommonsFactory;
import commons.meta.spi.AnnotationDescCreator;
import commons.meta.spi.AnnotationDescSupport;
import commons.meta.spi.BeanDescCreator;
import commons.meta.spi.DefaultAnnotationDescCreatorImpl;
import commons.meta.spi.DefaultBeanDescCreatorImpl;

/**
 * The concrete service class for Lucy environment.
 * 
 * @author shot
 */
public class LucyCommonsFactoryImpl implements CommonsFactory {

	protected AnnotationDescCreator annotationDescCreator;

	protected BeanDescCreator beanDescCreator;

	protected AopEngine engine;

	protected AnnotationDescSupport annotationDescSupport;

	@Override
	public void initialize() {
		annotationDescCreator = new DefaultAnnotationDescCreatorImpl(
				Composite.class);
		annotationDescSupport = new AnnotationDescSupportImpl();
		beanDescCreator = new DefaultBeanDescCreatorImpl();
		engine = new AopEngineImpl(new InterceptorDescStrategyImpl(),
				new SimpleEnahncedClassCacheImpl());
		engine.startup();
	}

	@Override
	public AnnotationDescCreator getAnnotationDescCreator() {
		return annotationDescCreator;
	}

	@Override
	public BeanDescCreator getBeanDescCreator() {
		return beanDescCreator;
	}

	@Override
	public AopEngine getAopEngine() {
		return engine;
	}

	@Override
	public void destroy() {
		engine.shutdown();
	}

	@Override
	public AnnotationDescSupport getAnnotationDescSupport() {
		return annotationDescSupport;
	}

}
