package lucy;

import lucy.exception.LucyStartupFailException;
import lucy.spi.LucyConfiguration;

import commons.Disposer;
import commons.bootstrap.CommonsInitializer;
import commons.util.Assertion;

/**
 * Bootstrap class for Lucy.
 * 
 * @author shot
 * 
 */
public final class LucyBootstrap {

	private static Lucy lucy;

	protected static boolean initialized = false;

	public static synchronized Lucy init() {
		return init((String) null);
	}

	public static synchronized Lucy init(final String componentDefinitionPath) {
		return init(new DefaultLucyConfiguration(), componentDefinitionPath);
	}

	public static synchronized Lucy init(final LucyConfiguration config) {
		return init(config, null);
	}

	public static synchronized Lucy init(final LucyConfiguration config,
			final Object componentDefinition) {
		Assertion.notNull(config);
		if (initialized) {
			return lucy;
		}
		CommonsInitializer.init();
		if (lucy == null) {
			lucy = new LucyImpl(config);
		}
		lucy.init();
		if (componentDefinition != null) {
			lucy.load(componentDefinition);
		}
		return lucy;
	}

	public static Lucy getLucy() {
		if (lucy == null) {
			throw new LucyStartupFailException();
		}
		return lucy;
	}

	public static void destroy() {
		if (lucy == null) {
			return;
		}
		lucy.destroy();
		lucy = null;
		Disposer.dispose();
		CommonsInitializer.destroy();
		initialized = false;
	}

	public static synchronized void setLucy(final Lucy lucy) {
		LucyBootstrap.lucy = Assertion.notNull(lucy);
	}

}
