package lucy;

import commons.meta.BeanDesc;
import commons.meta.PackageDescHolder;

/**
 * A simple IoC container without difficult things.
 * 
 * @author shot
 */
public interface Lucy extends PackageDescHolder {

	void init();

	void destroy();

	<T> Lucy register(Class<? extends T> componentClass);

	<T> Lucy register(T t);

	<T> Lucy register(Class<? extends T> componentClass, Object identifier);

	<T> Lucy register(T t, Object identifier);

	<T> Lucy register(BeanDesc<? extends T> beanDesc);

	<T> Lucy register(BeanDesc<? extends T> beanDesc, Object identifier);

	<T> T get(Class<? super T> key);

	<T> T get(Object identifier);

	<T> T[] getAll(Class<? super T> key);

	<T> BeanDesc<T> getBeanDesc(Object identifier);

	<T> BeanDesc<T>[] getBeanDescs(Class<? super T> key);

	<T> BeanDesc<T> getBeanDesc(Class<? super T> key);

	<T> boolean hasComponent(Class<T> key);

	boolean hasComponent(Object identifier);

	<T> T injectDependency(T t);

	void load(Object componentDefinition);
}
