package lucy;

/**
 * Lifecycle of Lucy itself and components.
 * 
 * @author shot
 */
public enum Lifecycle {
	/**
	 * Container configuration phase.
	 */
	CONTAINER_CONFIG,

	/**
	 * Class loading phase.
	 */
	CLASS_LOADING,

	/**
	 * Component creating phase.
	 */
	COMPONENT_CREATING,

	/**
	 * The phase just after components are created.
	 */
	COMPONENT_CREATED,

	/**
	 * Component initializing phase.
	 */
	COMPONENT_INITIALIZE,

	/**
	 * Component destroy phase.
	 */
	COMPONENT_DESTROY;

	/* CONTAINER_SHUTDOWN */

	public static Lifecycle[] getComponentLifecycle() {
		return new Lifecycle[] { CLASS_LOADING, COMPONENT_CREATING,
				COMPONENT_CREATED, COMPONENT_INITIALIZE, COMPONENT_DESTROY };
	}

	public static Lifecycle[] getContainerLifecycle() {
		return new Lifecycle[] { CONTAINER_CONFIG };
	}
}
