package lucy;

import lucy.spi.ComponentBuilder;
import lucy.spi.LucyConfiguration;

import commons.meta.BeanDesc;

/**
 * Base Lucy configuration.
 * 
 * @author shot
 */
public class DefaultLucyConfiguration implements LucyConfiguration {

	protected final ConfigDescBinder rootBinder;

	protected LucyComponentRegistrar<?> componentRegistrar;

	public DefaultLucyConfiguration() {
		rootBinder = ConfigDescBinderFactory.getConfigDescBinder(this);
		componentRegistrar = new XMLLucyComponentRegistrar();
	}

	@Override
	public ConfigDescBinder loadConfigDescBinder() {
		return rootBinder;
	}

	@Override
	public ComponentBuilder createBuilder(BeanDesc<?> beanDesc, Lucy lucy) {
		return ComponentBuilderFactory.createBuilder(beanDesc, lucy, this);
	}

	@Override
	public BeanDescStrategy getBeanDescStrategy(Lucy lucy) {
		return new DefaultBeanDescStrategyImpl(lucy);
	}

	@Override
	@SuppressWarnings("unchecked")
	public <R> LucyComponentRegistrar<R> getAcceptableComponentRegistrar(
			R resource) {
		if (componentRegistrar.accepts(resource)) {
			return (LucyComponentRegistrar<R>) componentRegistrar;
		} else {
			return null;
		}
	}

}
