package lucy;

import java.util.List;

import lucy.exception.TooManyRegistrationException;

import commons.meta.BeanDesc;
import commons.util.Assertion;

/**
 * DefaultBeanDescStrategyImpl is a strategy class of BeanDescFactory.
 * 
 * @author shot
 */
public class DefaultBeanDescStrategyImpl implements BeanDescStrategy {

	protected final Lucy lucy;

	public DefaultBeanDescStrategyImpl(Lucy lucy) {
		this.lucy = lucy;
	}

	@Override
	public <T> BeanDesc<T> getBeanDesc(Class<T> beanClass,
			List<BeanDesc<T>> list) {
		Assertion.notNull(beanClass);
		Assertion.notNull(list);
		if (list.size() == 1) {
			return list.get(0);
		} else {
			throw new TooManyRegistrationException(beanClass);
		}
	}

	@Override
	public <T> T handleNoBeanDesc(Object key) {
		return null;// if no beanDesc, simply return null.
	}

}
