package lucy;

import java.util.List;
import java.util.Map;

import lucy.spi.Behavior;

import commons.meta.BeanDesc;
import commons.meta.ClassDesc;
import commons.meta.DescType;
import commons.meta.MethodDesc;
import commons.meta.PropertyDesc;
import commons.util.Assertion;
import commons.util.CollectionsUtil;

/**
 * ConfigBindResult is a stored result of component.
 * 
 * @author shot
 */
public class ConfigBindResult {

	protected BeanDesc<?> beanDesc;

	protected boolean initialized = false;

	protected Map<DescType, List<Behavior>> map = CollectionsUtil
			.newLinkedHashMap();

	protected List<Behavior> allBehaviors = CollectionsUtil.newLinkedList();

	public ConfigBindResult(BeanDesc<?> beanDesc) {
		this.beanDesc = beanDesc;
	}

	public BeanDesc<?> getKey() {
		return beanDesc;
	}

	public void addBehavior(DescType desc, Behavior b) {
		Assertion.notNull(desc);
		Assertion.notNull(b);
		List<Behavior> list = map.get(desc);
		if (list == null) {
			list = CollectionsUtil.newArrayList();
		}
		list.add(b);
		map.put(desc, list);
		allBehaviors.add(b);
	}

	public Behavior getBehavior(int index) {
		return allBehaviors.get(index);
	}

	public int getBehaviorsSize() {
		return allBehaviors.size();
	}

	public List<Behavior> getBehaviorList(DescType desc) {
		return map.get(desc);
	}

	public boolean hasClassDesc(ClassDesc<?> cd) {
		return cd != null && map.containsKey(cd);
	}

	public boolean hasMethodDesc(MethodDesc md) {
		return md != null && map.containsKey(md);
	}

	public boolean hasPropertyDesc(PropertyDesc<?> pd) {
		return pd != null && map.containsKey(pd);
	}

	public void initializeBehaviors() {
		for (Behavior b : allBehaviors) {
			b.init();
		}
		initialized = true;
	}

	public void destroyBehaviors() {
		for (Behavior b : allBehaviors) {
			b.destroy();
		}
	}

	public boolean isInitialized() {
		return initialized;
	}

	public boolean isEmpty() {
		return map.isEmpty();
	}
}
