package lucy;

import java.util.List;

import commons.meta.BeanDesc;
import commons.util.CollectionsUtil;

/**
 * BeanDescBag is an wrapper class for BeanDesc to store.<br /> It is used for
 * component saving.<br />
 * 
 * @author Skirnir
 * @author shot
 */
public class BeanDescBag<T> {

	protected Class<T> beanClass;

	protected List<BeanDesc<T>> beanDescList = CollectionsUtil.newArrayList();

	protected BeanDescStrategy beanDescStrategy;

	public BeanDescBag(Class<T> beanClass, BeanDescStrategy beanDescStrategy) {
		this.beanClass = beanClass;
		this.beanDescStrategy = beanDescStrategy;
	}

	public void add(BeanDesc<T> beanDesc) {
		beanDescList.add(beanDesc);
	}

	public BeanDesc<T> getBeanDesc() {
		return beanDescStrategy.getBeanDesc(beanClass, beanDescList);
	}

	public List<BeanDesc<T>> getBeanDescList() {
		return beanDescList;
	}
}
