package lucy;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;

import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtMethod;
import lucy.aop.ClassPoolUtil;
import lucy.aop.JavassistUtil;
import lucy.aop.LucyClassPool;
import lucy.aop.impl.ClassEnhanceHelper.LucyCtNewMethod;

import commons.Constants;
import commons.meta.spi.AnnotationDescSupport;
import commons.util.Assertion;
import commons.util.Reflections.ClassLoaderUtil;
import commons.util.Reflections.ClassUtil;
import commons.util.Reflections.MethodUtil;

/**
 * AnnotationDescSupportImpl is the class to create annotation with changed
 * value using AOP.See test class if you would like to know what we would like
 * to do.
 * 
 * This class is very experimental class, so not stable.
 * 
 * @author shot
 * 
 */
public class AnnotationDescSupportImpl implements AnnotationDescSupport {

	@SuppressWarnings("unchecked")
	@Override
	public <T extends Annotation> T createAnnotation(final T original,
			final String targetMethodName, final Object replaceValue) {
		Assertion.notNull(original, "original");
		Assertion.notNull(targetMethodName, "targetMethodName");
		Assertion.notNull(replaceValue, "value");

		final Class<? extends Annotation> orgClass = original.annotationType();
		final LucyClassPool pool = ClassPoolUtil.getClassPool(orgClass);
		final CtClass replacedCtClass = createNewCtClass(orgClass, pool);

		addAnnotationTypeMethod(orgClass, replacedCtClass, pool);

		for (Method m : orgClass.getDeclaredMethods()) {
			final String methodName = m.getName();
			boolean valueReplace = methodName.equals(targetMethodName);
			Class<?> returnType = m.getReturnType();
			final Object value = (valueReplace) ? replaceValue : MethodUtil
					.invoke(m, original, Constants.EMPTY_ARRAY);
			StringBuilder body = new StringBuilder(50);
			if (returnType == String.class) {
				body.append("{return \"");
				body.append(value.toString());
				body.append("\";}");
			} else if (returnType == Class.class) {
				body.append("{return ");
				body.append(orgClass.getName());
				body.append(".class;}");
			} else if (Enum.class.isAssignableFrom(returnType)) {
				final Enum e = (Enum) value;
				final String name = e.getDeclaringClass().getName();
				body.append("{return ");
				body.append(name + "." + value.toString());
				body.append(";}");
			} else if (Annotation.class.isAssignableFrom(returnType)) {
				// TODO we do not support nested annotation.
				continue;
			} else if (returnType.isArray()) {
				// TODO not impl yet.
				continue;
			} else {
				body.append("{return ");
				body.append(value);
				body.append(";}");
			}
			createAndAddCtMethod(replacedCtClass, pool, m, methodName, body
					.toString());
		}
		final ClassLoader classLoader = ClassLoaderUtil.getClassLoader(original
				.annotationType());
		try {
			return (T) toClass(replacedCtClass, classLoader);
		} finally {
			destroy(replacedCtClass);
		}
	}

	protected void destroy(CtClass ctClass) {
		ctClass.detach();
		ctClass = null;
	}

	protected synchronized Object toClass(final CtClass ctClass,
			final ClassLoader classLoader) {
		Class<?> class1 = JavassistUtil.toClass(ctClass, classLoader);
		return ClassUtil.newInstance(class1);
	}

	protected CtClass createNewCtClass(
			Class<? extends Annotation> annotationClass, ClassPool pool) {
		final String name = annotationClass.getName();
		final String classNameCandidate = name + "$$" + System.nanoTime();
		final CtClass replacedCtClass = JavassistUtil.makeCtClass(pool,
				classNameCandidate, Object.class);
		replacedCtClass.setInterfaces(new CtClass[] { JavassistUtil.getCtClass(
				pool, annotationClass) });
		JavassistUtil.addDefaultConstructor(replacedCtClass);
		return replacedCtClass;
	}

	protected void addAnnotationTypeMethod(
			Class<? extends Annotation> annotationClass, CtClass ctClass,
			LucyClassPool pool) {
		Method annotationTypeMethod = MethodUtil.getMethod(annotationClass,
				ANNOTATIONTYPE_METHOD_NAME, Constants.EMPTY_CLASS_ARRAY);
		String annotationTypeBody = "{return " + annotationClass.getName()
				+ ".class;}";
		createAndAddCtMethod(ctClass, pool, annotationTypeMethod,
				ANNOTATIONTYPE_METHOD_NAME, annotationTypeBody);
	}

	protected void createAndAddCtMethod(CtClass ctClass, LucyClassPool pool,
			Method method, String methodName, String body) {
		CtMethod annotationTypeCtMethod = LucyCtNewMethod.make(ctClass, pool,
				method, methodName, body);
		JavassistUtil.addCtMethod(ctClass, annotationTypeCtMethod);
	}
}
