package commons.util;

import java.io.File;
import java.net.URL;

/**
 * ZipFileUtil is an utility class for using ZipFile.
 * 
 * @author shot
 */
public class ZipFileUtil {

	private ZipFileUtil() {
	}

	public static String toZipFilePath(final URL zipUrl) {
		Assertion.notNull(zipUrl, "zipUrl");
		final String urlString = zipUrl.getPath();
		final int pos = urlString.lastIndexOf('!');
		final String zipFilePath = urlString.substring(0, pos);
		final File zipFile = new File(URLUtil.decode(zipFilePath, "UTF8"));
		return FileUtil.getCanonicalPath(zipFile);
	}
}
