package commons.util;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;

import commons.exception.IORuntimeException;

/**
 * Writer utility class.
 * 
 * @author shot
 * 
 */
public class WriterUtil {

	public static FileWriter createFileWriter(final File file) {
		Assertion.notNull(file);
		try {
			return new FileWriter(file);
		} catch (IOException e) {
			throw new IORuntimeException(e);
		}
	}

	public static PrintWriter createPrintWriter(final Writer writer) {
		Assertion.notNull(writer);
		return new PrintWriter(writer) {
			@Override
			public void close() {
				try {
					synchronized (lock) {
						if (out == null)
							return;
						out.close();
						out = null;
					}
				} catch (IOException x) {
					throw new IORuntimeException(x);
				}
			}
		};
	}

	public static PrintWriter createPrintWriter(final File file) {
		Assertion.notNull(file);
		return createPrintWriter(createFileWriter(file));
	}

	public static void close(PrintWriter writer) {
		Assertion.notNull(writer);
		writer.close();
	}
}
