package commons.util;

import java.nio.charset.Charset;
import java.util.Map;

/**
 * System property utility.
 * 
 * @author shot
 * 
 */
public class SystemPropertyUtil {

	private static final Map<String, String> cache = CollectionsUtil
			.newHashMap();

	public static final String LINE_SEP = System.getProperty("line.separator");

	public static final String PATH_SEP = System.getProperty("path.separator");

	public static final String TMP_DIR = System.getProperty("java.io.tmpdir");

	public static final String FILE_ENCODING = Charset.defaultCharset().name();

	static {
		cache.put("line.separator", LINE_SEP);
		cache.put("path.separator", PATH_SEP);
		cache.put("java.io.tmpdir", TMP_DIR);
		cache.put("file.encoding", FILE_ENCODING);
	}

	public static String get(final String key) {
		return cache.get(Assertion.notNull(key));
	}

}
