package commons.util;

import java.util.List;
import java.util.StringTokenizer;

import commons.Constants;

/**
 * String utility.
 * 
 * @author shot
 */
public final class StringUtil {

	protected StringUtil() {
	}

	public static boolean isEmpty(String text) {
		return text == null || text.length() == 0;
	}

	public static boolean isAllEmpty(String[] regexes) {
		if (regexes == null) {
			return false;
		}
		for (String regex : regexes) {
			if (!isEmpty(regex)) {
				return false;
			}
		}
		return true;
	}

	public static String replace(String text, String fromText, String toText) {
		if (Assertion.hasNull(text, fromText, toText)) {
			return text;
		}
		if (isEmpty(fromText) && isEmpty(toText)) {
			return text;
		}
		StringBuilder buf = new StringBuilder(100);
		int from = 0;
		int to = 0;
		while (true) {
			to = text.indexOf(fromText, from);
			if (to == 0) {
				buf.append(toText);
				from = fromText.length();
			} else if (to > 0) {
				buf.append(text.substring(from, to));
				buf.append(toText);
				from = to + fromText.length();
			} else {
				buf.append(text.substring(from));
				break;
			}
		}
		return buf.toString();
	}

	public static String[] split(String str, String delim) {
		if (isEmpty(str)) {
			return Constants.EMPTY_STRING_ARRAY;
		}
		List<String> list = CollectionsUtil.newArrayList();
		StringTokenizer st = new StringTokenizer(str, delim);
		while (st.hasMoreElements()) {
			list.add((String) st.nextElement());
		}
		return list.toArray(new String[list.size()]);
	}

	public static final String leftTrim(final String text) {
		return leftTrim(text, null);
	}

	public static final String leftTrim(final String text, String trimText) {
		if (text == null) {
			return null;
		}
		if (trimText == null) {
			trimText = " ";
		}
		int pos = 0;
		for (; pos < text.length(); pos++) {
			if (trimText.indexOf(text.charAt(pos)) < 0) {
				break;
			}
		}
		return text.substring(pos);
	}

	public static final String rightTrim(final String text) {
		return rightTrim(text, null);
	}

	public static final String rightTrim(final String text, String trimText) {
		if (text == null) {
			return null;
		}
		if (trimText == null) {
			trimText = " ";
		}
		int pos = text.length() - 1;
		for (; pos >= 0; pos--) {
			if (trimText.indexOf(text.charAt(pos)) < 0) {
				break;
			}
		}
		return text.substring(0, pos + 1);
	}

	public static final String trimSuffix(final String text, String suffix) {
		if (text == null) {
			return null;
		}
		if (suffix == null) {
			return text;
		}
		if (text.endsWith(suffix)) {
			return text.substring(0, text.length() - suffix.length());
		}
		return text;
	}

	public static final String trimPrefix(final String text, String prefix) {
		if (text == null) {
			return null;
		}
		if (prefix == null) {
			return text;
		}
		if (text.startsWith(prefix)) {
			return text.substring(prefix.length());
		}
		return text;
	}

	public static String decapitalize(String name) {
		if (isEmpty(name)) {
			return name;
		}
		char chars[] = name.toCharArray();
		if (chars.length >= 2 && Character.isUpperCase(chars[0])
				&& Character.isUpperCase(chars[1])) {
			return name;
		}
		chars[0] = Character.toLowerCase(chars[0]);
		return new String(chars);
	}

	public static String capitalize(String name) {
		if (isEmpty(name)) {
			return name;
		}
		char chars[] = name.toCharArray();
		chars[0] = Character.toUpperCase(chars[0]);
		return new String(chars);
	}

	public static boolean startsWith(String text, String fragment) {
		return startsWithIgnoreCase(text, fragment);
	}

	public static boolean isBlank(String str) {
		if (str == null || str.length() == 0) {
			return true;
		}
		for (int i = 0; i < str.length(); i++) {
			if (!Character.isWhitespace(str.charAt(i))) {
				return false;
			}
		}
		return true;
	}

	public static boolean isNotBlank(String str) {
		return !isBlank(str);
	}

	public static boolean contains(String str, char ch) {
		if (isEmpty(str)) {
			return false;
		}
		return str.indexOf(ch) >= 0;
	}

	public static boolean contains(String s1, String s2) {
		if (isEmpty(s1)) {
			return false;
		}
		return s1.indexOf(s2) >= 0;
	}

	public static boolean equals(String target1, String target2) {
		return (target1 == null) ? (target2 == null) : target1.equals(target2);
	}

	public static boolean equalsIgnoreCase(String target1, String target2) {
		return (target1 == null) ? (target2 == null) : target1
				.equalsIgnoreCase(target2);
	}

	public static boolean endsWithIgnoreCase(String target1, String target2) {
		if (target1 == null || target2 == null) {
			return false;
		}
		int length1 = target1.length();
		int length2 = target2.length();
		if (length1 < length2) {
			return false;
		}
		String s1 = target1.substring(length1 - length2);
		return s1.equalsIgnoreCase(target2);
	}

	public static boolean startsWithIgnoreCase(String target1, String target2) {
		if (target1 == null || target2 == null) {
			return false;
		}
		int length1 = target1.length();
		int length2 = target2.length();
		if (length1 < length2) {
			return false;
		}
		String s1 = target1.substring(0, target2.length());
		return s1.equalsIgnoreCase(target2);
	}

	public static String substringFromLast(String str, String separator) {
		if (isEmpty(str) || isEmpty(separator)) {
			return str;
		}
		int pos = str.lastIndexOf(separator);
		if (pos == -1) {
			return str;
		}
		return str.substring(0, pos);
	}

	public static String substringToLast(String str, String separator) {
		if (isEmpty(str) || isEmpty(separator)) {
			return str;
		}
		int pos = str.lastIndexOf(separator);
		if (pos == -1) {
			return str;
		}
		return str.substring(pos + 1, str.length());
	}

	public static String toHex(byte[] bytes) {
		if (bytes == null) {
			return "";
		}
		StringBuffer sb = new StringBuffer(bytes.length * 2);
		for (int i = 0; i < bytes.length; ++i) {
			appendHex(sb, bytes[i]);
		}
		return sb.toString();
	}

	public static String toHex(final int i) {
		StringBuffer buf = new StringBuffer();
		appendHex(buf, i);
		return buf.toString();
	}

	public static void appendHex(final StringBuffer buf, final byte i) {
		buf.append(Character.forDigit((i & 0xf0) >> 4, 16));
		buf.append(Character.forDigit((i & 0x0f), 16));
	}

	public static void appendHex(final StringBuffer buf, final int i) {
		buf.append(Integer.toHexString((i >> 24) & 0xff));
		buf.append(Integer.toHexString((i >> 16) & 0xff));
		buf.append(Integer.toHexString((i >> 8) & 0xff));
		buf.append(Integer.toHexString(i & 0xff));
	}

	public static int counts(final String str, final char target) {
		Assertion.notNull(str);
		int ret = 0;
		for (int i = 0; i < str.length(); i++) {
			char charAt = str.charAt(i);
			if (charAt == target) {
				ret++;
			}
		}
		return ret;
	}

	public static Integer[] getPosition(final String str, final char target) {
		Assertion.notNull(str);
		List<Integer> retList = CollectionsUtil.newArrayList();
		for (int i = 0; i < str.length(); i++) {
			char charAt = str.charAt(i);
			if (charAt == target) {
				retList.add(Integer.valueOf(i));
			}
		}
		return retList.toArray(new Integer[0]);
	}

	public static String toString(Object o) {
		return toString(o, "");
	}

	public static String toString(Object o, String defaultValue) {
		return o == null ? defaultValue : o.toString();
	}
}