package commons.util;

import java.io.InputStream;

import javax.xml.stream.EventFilter;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;

import commons.exception.XMLStreamRuntimeException;

/**
 * Utility class of StAX.
 * 
 * @author shot
 * 
 */
public class StAXUtil {

	public static XMLEventReader createXMLEventReader(XMLInputFactory factory,
			InputStream is) {
		Assertion.notNulls(factory, is);
		try {
			return factory.createXMLEventReader(is);
		} catch (XMLStreamException e) {
			throw new XMLStreamRuntimeException(e);
		}
	}

	public static XMLEventReader createFilteredReader(XMLInputFactory factory,
			XMLEventReader reader, EventFilter filter) {
		try {
			return factory.createFilteredReader(reader, filter);
		} catch (XMLStreamException e) {
			throw new XMLStreamRuntimeException(e);
		}
	}
}
