package commons.util;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Map;
import java.util.StringTokenizer;

import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import commons.Constants;
import commons.exception.ForwardDispatchRuntimeException;
import commons.exception.RedirectDispatchRuntimeException;

/**
 * Servlet utility class.
 * 
 * @author shot
 * 
 */
public class ServletUtil {

	public static void forward(final RequestDispatcher dispatcher,
			final HttpServletRequest request, final HttpServletResponse response) {
		Assertion.notNulls(dispatcher, request, response);
		try {
			dispatcher.forward(request, response);
		} catch (ServletException e) {
			throw new ForwardDispatchRuntimeException(e);
		} catch (IOException e) {
			throw new ForwardDispatchRuntimeException(e);
		}
	}

	public static Map<String, String[]> parseParameters(String param,
			String encoding) throws UnsupportedEncodingException {
		Map<String, String[]> map = CollectionsUtil.newHashMap();
		StringTokenizer st = new StringTokenizer(param, "&");
		while (st.hasMoreTokens()) {
			String tkn = st.nextToken();
			int equal = tkn.indexOf("=");
			String name;
			String value;
			if (equal >= 0) {
				name = tkn.substring(0, equal);
				value = tkn.substring(equal + 1);
			} else {
				name = tkn;
				value = "";
			}
			name = URLDecoder.decode(name, encoding);
			value = URLDecoder.decode(value, encoding);
			String[] current = map.get(name);
			if (current == null) {
				map.put(name, new String[] { value });
			} else {
				map.put(name, (String[]) ArrayUtil.add(current, value));
			}
		}
		return map;
	}

	public static void redirect(final HttpServletResponse response,
			final String path) {
		Assertion.notNulls(response, path);
		try {
			response.sendRedirect(path);
		} catch (IOException e) {
			throw new RedirectDispatchRuntimeException(e, path);
		}
	}

	public static boolean isMultipart(final HttpServletRequest request) {
		Assertion.notNull(request);
		String method = request.getMethod().toUpperCase();
		if (!"POST".equals(method)) {
			return false;
		}
		final String contentType = request.getContentType();
		if (StringUtil.isEmpty(contentType)) {
			return false;
		}
		return contentType.indexOf(Constants.MULTIPART) >= 0;
	}
}
